//
//  MCTextTemplateView.h
//  MCApplication
//
//  Created by Alykhan Jetha on 23/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//


/*
 This class is designed to be used as a view. It's purpose is to take a RTF or TXT template and merge it using the MergeEngine. While you can save the merged contents to a file, the object is not meant to be a mutable editor. You may coax it to accept minor changes with some work (namely setEditable on NSTextView).
 
 Encodings
 There are 2 types of encoding in play. One is the TextEdit document encodings (since people may create the templates in TextEdit, we have to support those.
 The second encoding is the string encoding. This encoding value is used to after the merge to return a NSData. You can set the encoding (mergeEncoding) which is recommended so that there is no confusion. If no merge encoding is set, the document will be asked for it's 'stringEncoding', if the document does not respond to that method, NSMacOSRomanStringEncoding is used.

 In most cases, that will be fine, when using non roman languages, you should set the explicitly set the encoding (using the NSStringEncoding typedefs). You can set this on a per template basis (i.e put the encoding in the Info plist of the template - NSStringEncoding = 33 or whatever the value may be)
 
 */



#import <Cocoa/Cocoa.h>


/* Returns the default padding on the left/right edges of text views */
float textTemplateDefaultTextPadding(void);

@class MCScalingScrollView;

@interface MCTextTemplateView : NSView {

	id model;
	id document;
	id delegate; // not retained
	
	NSString *templateString;
	
	NSTextStorage *textStorage;
    NSPrintInfo *printInfo;
	
    MCScalingScrollView *scrollView;

	BOOL hasMultiplePages;
    BOOL isRichText;

	NSStringEncoding mergeEncoding;
	unsigned documentEncoding;
}


- (NSTextStorage *)textStorage;
- (NSTextView *)firstTextView;

- (NSLayoutManager *)layoutManager;
- (id)documentView;

- (void)setHyphenationFactor:(float)factor;
- (float)hyphenationFactor;

- (void)setRichText:(BOOL)flag;
- (BOOL)isRichText;

- (NSStringEncoding)mergeEncoding;
- (void)setMergeEncoding:(NSStringEncoding)aMergeEncoding;

// TextEdit compatibility
- (unsigned)encoding;
- (void)setEncoding:(unsigned)encoding;

- (void)setModel:(id)aModel;
- (id)model;

- (void)setDocument:(id)aDoc;
- (id)document;

- (void)setDelegate:(id)aDelegate;
- (id)delegate;

- (NSString *)templateString;
- (void)setTemplateString:(NSString *)aTemplateString;

// does the merge - call this after setting the model, delegate, document, templateString
- (NSData *)processMerge;

- (void)clearContents;

	/* Page-oriented methods */
- (void)addPage;
- (void)removePage;
- (unsigned)numberOfPages;
- (void)setHasMultiplePages:(BOOL)flag;
- (void)setHasMultiplePages:(BOOL)flag force:(BOOL)force;
- (BOOL)hasMultiplePages;
- (void)setPrintInfo:(NSPrintInfo *)anObject;
- (NSPrintInfo *)printInfo;
- (void)printInfoUpdated;	// To let the document know that printInfo has been changed
- (void)setPaperSize:(NSSize)size;
- (NSSize)paperSize;


- (NSMutableDictionary *)savingDocumentAttributes;
- (BOOL)writeToFile:(NSString *)aPath atomically:(BOOL)atom;


- (BOOL)loadMergedContentFromData:(NSData *)data encoding:(unsigned)encoding;
- (void)configureForDocumentAttributes:(NSDictionary *)docAttrs;

@end

@interface NSObject (MCTextTemplateViewDelegate)
/* Gives the delegate the opportunity to add keys to the merge pack. The delegate may replace keys, but it 
should not remove them.

document
objectContext
model

are required keys

*/
- (void)textTemplateView:(MCTextTemplateView *)aTemplateView 
	 isAboutToUseMergePack:(NSMutableDictionary *)aMergePack;
@end

